/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.base.Preconditions;
import java.util.List;
import org.simmetrics.ListMetric;
import org.simmetrics.StringMetric;

public final class MongeElkan
implements ListMetric<String> {
    private final StringMetric metric;

    public MongeElkan(StringMetric metric) {
        this.metric = metric;
    }

    @Override
    public float compare(List<String> a, List<String> b) {
        Preconditions.checkArgument((!a.contains(null) ? 1 : 0) != 0, (Object)"a may not not contain null");
        Preconditions.checkArgument((!b.contains(null) ? 1 : 0) != 0, (Object)"b may not not contain null");
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        return (float)Math.sqrt(this.mongeElkan(a, b) * this.mongeElkan(b, a));
    }

    private float mongeElkan(List<String> a, List<String> b) {
        float sum = 0.0f;
        for (String s : a) {
            float max = 0.0f;
            for (String q : b) {
                max = Math.max(max, this.metric.compare(s, q));
            }
            sum += max;
        }
        return sum / (float)a.size();
    }

    public String toString() {
        return "MongeElkan [metric=" + String.valueOf(this.metric) + "]";
    }
}

